//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

FocusScope {
    id : uiSearchBox

    property alias searchString : input.text
    property alias placeHolderText : placeHolder.text
    property alias font : input.font

    property UiSearchBoxVisualStyle visualStyle : null

    activeFocusOnTab : true

    onActiveFocusChanged : {
        if (activeFocus) {
            input.forceActiveFocus()
        }
    }

    implicitWidth  : 150
    implicitHeight : input.implicitHeight - 1

    function reset() {
        input.text   = "";
    }

    Rectangle {
        id : background

        anchors.fill : parent
        color        : UiColors.getColor(UiColors.White)
        z            : -1
        border {
            width : 1
            color : UiColors.getColor(UiColors.ControlGrey20)
        }

        states : State {
            name : "thick-border"
            when : uiSearchBox.searchString !== "" ||
                   uiSearchBox.activeFocus

            PropertyChanges {
                target          : background
                border.width    : 3
                anchors.margins : -2
            }
        }
    }

    states : [
        State {
            name : "disabled"
            when : !uiSearchBox.enabled

            PropertyChanges {
                target       : background
                border.color : UiColors.getColor(
                                   UiColors.DisabledLightGrey13)
            }
            PropertyChanges {
                target   : icon
                disabled : 1
            }
            PropertyChanges {
                target  : placeHolder
                opacity : .6
            }
        },
        State {
            name : "focus"
            when : uiSearchBox.activeFocus || uiSearchBox.searchString !== ""

            PropertyChanges {
                target       : background
                border.color : uiSearchBox.visualStyle ?
                                   uiSearchBox.visualStyle.selectionColor :
                                   UiColors.getColor(UiColors.SelectionGreen)
            }
            PropertyChanges {
                target  : placeHolder
                opacity : .6
            }
        },
        State {
            name : "hover"
            when : hoverArea.containsMouse

            PropertyChanges {
                target       : background
                border.color : uiSearchBox.visualStyle ?
                                   uiSearchBox.visualStyle.hoverColor :
                                   UiColors.getColor(UiColors.HoverGreen)
            }
        }
    ]

    TextInput {
        id : input

        anchors {
            fill        : parent
            rightMargin : 30
        }

        leftPadding   : 6
        topPadding    : 4
        bottomPadding : 4
        rightPadding  : 6

        font  : UiFonts.getFont(UiFonts.Light, 14)
        color : UiColors.getColor(UiColors.DarkGrey80)

        selectByMouse     : true
        selectionColor    : uiSearchBox.visualStyle ?
                                uiSearchBox.visualStyle.selectionColor :
                                UiColors.getColor(UiColors.SelectionGreen)
        selectedTextColor : UiColors.getColor(UiColors.White)
        clip              : true

        states : State {
            name : "disabled"
            when : !input.enabled

            PropertyChanges {
                target  : input
                color   : UiColors.getColor(UiColors.MediumLightGrey27)
            }
        }
    }

    UiText {
        id : placeHolder

        anchors {
            left           : parent.left
            leftMargin     : 6
            verticalCenter : parent.verticalCenter
        }
        font    : input.font
        text    : qsTrId("0918382c8d4b362e")
        color   : UiColors.getColor(UiColors.MediumLightGrey27)
        visible : uiSearchBox.searchString === ""
    }

    MouseArea {
        id : hoverArea

        anchors.fill    : parent
        hoverEnabled    : true
        acceptedButtons : Qt.NoButton
        cursorShape     : Qt.IBeamCursor
    }

    Item {
        anchors {
            top     : parent.top
            right   : parent.right
            bottom  : parent.bottom
            margins : 1
        }
        width : 30

        states : State {
            name   : "filled"
            when   : uiSearchBox.searchString !== ""

            PropertyChanges {
                target : icon
                scale  : .05
                opacity : 0
            }
            PropertyChanges {
                target  : clearButton
                scale   : 1
                opacity : 1
            }
        }

        transitions : Transition {
            NumberAnimation {
                targets     : [ icon, clearButton ]
                duration    : 250
                easing.type : Easing.InOutSine
                properties  : "opacity,scale"
            }
        }

        UiIcon {
            id : icon

            iconName : "search"
            scale    : 1
            opacity  : 1

            anchors.centerIn : parent
        }

        MouseArea {
            anchors.fill : parent
            onClicked    : input.forceActiveFocus();
            cursorShape  : Qt.PointingHandCursor
        }

        UiToolButton {
            id : clearButton

            iconName : "close"
            iconSize : UiIcon.Icon_16x16
            scale    : .05
            opacity  : 0
            visualStyle : UiToolButtonVisualStyle {
                hoverColor : uiSearchBox.visualStyle ?
                                 uiSearchBox.visualStyle.hoverColor :
                                 UiColors.getColor(UiColors.HoverGreen)

                selectionColor : uiSearchBox.visualStyle ?
                                     uiSearchBox.visualStyle.selectionColor :
                                     UiColors.getColor(UiColors.SelectionGreen)
            }

            anchors.fill : parent

            onClicked : uiSearchBox.reset()
        }
    }
}
